# Esercizio Sudoku

# DATI
param N;
set Cifre := 1..N*N;
set Righe := 1..N*N;
set Colonne := 1..N*N;
set MacroR := 1..N;
set MacroC := 1..N;
param lb {Righe,Colonne,Cifre};

# VARIABILI
var x {i in Righe,j in Colonne,k in Cifre} binary, >= lb[i,j,k];

# VINCOLI
# Una cifra per ogni coppia (riga,colonna)
subject to Cifra {i in Righe, j in Colonne}:
  sum {k in Cifre} x[i,j,k] = 1;
# Una colonna per ogni coppia (riga,cifra)
subject to Colonna {i in Righe, k in Cifre}:
  sum {j in Colonne} x[i,j,k] = 1;
# Una riga per ogni coppia (colonna,cifra)
subject to Riga {j in Colonne, k in Cifre}:
  sum {i in Righe} x[i,j,k] = 1;
# Una volta ogni cifra e ogni quadrato
subject to Quadrato {r in MacroR, c in MacroC, k in Cifre}:
  sum {i in Righe, j in Colonne: 
       (i>=(r-1)*N+1) and (i<=r*N) 
   and (j>=(c-1)*N+1) and (j<=c*N)} x[i,j,k] = 1;

#############
data;

param N := 3;

param lb :=
[1, 1, 8] 1
[1, 2, 5] 1
[1, 6, 2] 1
[1, 7, 4] 1
[2, 1, 7] 1
[2, 2, 2] 1
[2, 9, 9] 1
[3, 3, 4] 1
[4, 4, 1] 1
[4, 6, 7] 1
[4, 9, 2] 1
[5, 1, 3] 1
[5, 3, 5] 1
[5, 7, 9] 1
[6, 2, 4] 1
[7, 5, 8] 1
[7, 8, 7] 1
[8, 2, 1] 1
[8, 3, 7] 1
[9, 5, 3] 1
[9, 6, 6] 1
[9, 8, 4] 1;

end;

8 5 - - - 2 4 - -
7 2 - - - - - - 9
- - 4 - - - - - -
- - - 1 - 7 - - 2
3 - 5 - - - 9 - -
- 4 - - - - - - -
- - - - 8 - - 7 -
- 1 7 - - - - - -
- - - - 3 6 - 4 -
